#include "GetPoint.js"

function UpdatePrompt( oldprompt, newprompt, islast )
{
	var ui = moi.ui;
	ui.beginUIUpdate();
	ui.hideUI( oldprompt );
	ui.showUI( newprompt );
	
	if ( islast )
		ui.showUI( 'ConicOptions' );
	
	ui.endUIUpdate();
}

function DoConic()
{
	var ui = moi.ui;
	var pointpicker = ui.createPointPicker();
	
	var factory = moi.command.createFactory( 'conic' );

	pointpicker.bindResultPt( factory.getInput(0) );
	if ( !GetPoint( pointpicker ) )
		return;

	UpdatePrompt( 'Prompt1', 'Prompt2' );
	pointpicker.clearBindings();	
	pointpicker.bindResultPt( factory.getInput(1) );
	if ( !GetPoint( pointpicker ) )
		return;

	UpdatePrompt( 'Prompt2', 'Prompt3' );	
	pointpicker.clearBindings();	
	pointpicker.bindResultPt( factory.getInput(2) );
	factory.setTanTanSnapPt( pointpicker );
	if ( !GetPoint( pointpicker ) )
		return;
		
	UpdatePrompt( 'Prompt3', 'Prompt4', true );
	pointpicker.clearSnapPoints();
	pointpicker.clearBindings();
	pointpicker.bindResultPt( factory.getInput(3) );
	ui.commandUI.g_ConicFactory = factory;	
	pointpicker.bindFuncPostUpdate( ui.commandUI.OnPoint );
	pointpicker.disableVerticalStraightSnap = true;
	factory.setPlane( pointpicker );
	
	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return;
			
		if ( pointpicker.event == 'finished' )
			break;
			
		if ( pointpicker.event == 'rhoinput' )
		{
			var val = ui.commandUI.rhoinput.value;
			if ( val < 1.0 && val != 0.0 )
			{
				factory.setInput( 4, val );
				factory.update();
				break;
			}
		}
	}

	factory.commit();
}

DoConic();
